<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Add Bulk Links
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

        <?php
        echo $this->Form->create('Link', array(
            'inputDefaults' => array(
                'label' => false,
                'div' => false,
                'class' => 'form-control placeholder-no-fix',
                'error' => array(
                    'attributes' => array('wrap' => 'span', 'class' => 'help-block')
                )
            )
        ));
        ?>

        <div class="form-group <?php echo($this->Form->isFieldError('bulk_links') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkBulkLinks">Bulk Links</label>
            <?php echo $this->Form->input('bulk_links', array('type' => 'textarea')); ?>
        </div>

        <?php $timers = unserialize(Configure::read('Option.timers')); ?>
        <div class="form-group <?php echo($this->Form->isFieldError('timer') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkTimer">Timer</label>
            <?php
            echo $this->Form->input('timer', array(
                'min' => 1,
                'max' => 60,
                'value' => $this->Session->read('Auth.User.timer'),
                    //'options' => $timers,
            ));
            ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('bundle_id') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkBundleId">Bundle</label>
            <?php
            echo $this->Form->input('bundle_id', array(
                'options' => $bundles,
                'empty' => 'Select Bundle'
            ));
            ?>
        </div>
        <?php echo $this->Form->end(array('label' => 'Submit', 'class' => 'btn btn-primary btn-lg pull-right')); ?>


    </div>
</div>
<!-- END PAGE CONTENT-->
